<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <title>Pārvaldīt Testus</title>
    <link rel="stylesheet" type="text/css" href="../style.css">
    <style>

h1 {
  text-align: center;
  margin-top: 20px;
  font-size: 24px;
}

.test-table {
  width: 80%;
  margin: 20px auto;
  border-collapse: collapse;
}

.test-table th, .test-table td {
  border: 1px solid #ccc;
  padding: 10px;
  text-align: center;
}

.test-table th {
  background-color: #f4f4f4;
}

.test-table a {
  padding: 5px 10px;
  background-color: #333;
  color: #fff;
  text-decoration: none;

  transition: background-color 0.3s ease;
}

.test-table a:hover {
  background-color: #555;
}

/* Style for the edit and delete buttons */
.actions button {
    padding: 5px 10px;
            background-color: #333;
            color: #fff;
            text-decoration: none;
            border-radius: 3px;
            transition: background-color 0.3s ease;
}

.actions button:hover {
  background-color: #777;
  transition: background-color 0.3s ease;
}

        /* Style for the admin button */
#adminBtn {
  margin: 0 auto; /* Centers the button horizontally */
}

#adminBtn a {
  text-decoration: none;
  color: white;
  padding: 10px 20px;
  border-radius: 5px;
  background-color: #555;
  transition: background-color 0.3s ease;
}

/* Hover effect for the admin button */
#adminBtn a:hover {
  background-color: #777;
}

    </style>
</head>
<body>
    <?php include('../php/check_admin.php'); ?>
    
 <!-- Navigācijas josla -->
<div id="navbar">
    <!-- Left-aligned logo -->
    <div id="logo" >LOGO</div>
    <div id="adminBtn">
        <a href="../html/admin_view.html">Admin View</a>
    </div>   
    <div id="profileBtn" class="dropdown" onclick="toggleDropdown()">Profils
        <div class="dropdown-content" id="dropdownContent">
            <a href="../php/logout.php">Iziet</a>
        </div>
    </div>
</div>




    <h1>Pārvaldīt Testus</h1>
    <table class="test-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Nosaukums</th>
                <th>Kategorija</th>
                <th>Darbības</th>
            </tr>
        </thead>
        <tbody>
            <?php
            // Datu bāzes savienojums
            $conn = new mysqli("localhost", "root", "", "quiz_db");
            if ($conn->connect_error) {
                die("Savienojums neizdevās: " . $conn->connect_error);
            }

            $sql = "SELECT id, name, category FROM tests";
            $result = $conn->query($sql);

            if ($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {
                    echo "<tr>";
                    echo "<td>" . $row["id"] . "</td>";
                    echo "<td>" . $row["name"] . "</td>";
                    echo "<td>" . $row["category"] . "</td>";
                    
                    echo "<td class='actions'>
                            <button onclick='editTest(" . $row["id"] . ")'>Rediģēt</button>
                            <button onclick='deleteTest(" . $row["id"] . ")'>Dzēst</button>
                          </td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='5'>Testi nav atrasti.</td></tr>";
            }

            $conn->close();
            ?>
        </tbody>
    </table>

    <script src="../js/redirects.js"></script>
    <script>
        function editTest(testId) {
            window.location.href = '../php/admin_edit_test.php?test_id=' + testId;
        }

        function deleteTest(testId) {
            if (confirm("Vai tiešām vēlaties dzēst šo testu?")) {
                window.location.href = '../php/delete_test.php?test_id=' + testId;
            }
        }
    </script>
</body>
</html>
